

%SPF1, SPF4, SPF40, MEDCPI, LAG, UGAP/outputgap
clear all;  % clear all variables
close all;  % close all graphs
clc;
obsd=open('datatask9.mat');
obs=obsd.datareg(:,2)-obsd.datareg(:,5);
z=2.5 - obsd.datareg(:,5);


sigma=fminsearch(@LogLikelihood,[0,0]);
%sigma=fminsearch(@LogLikelihood,[0]);
[upd,pred,T,V,S,F]=KalmanFilter (sigma, obs);
smooth=KalmanSmoother(T,upd,pred);

save('sigma', 'sigma');

subplot(2,1,1)
plot(obs);
hold on;
title('Observation and Kalman Filter Prediction (Dashed line is updated series)')
plot(upd(2:end,1),'--r','Linewidth',2);
hold off;

subplot(2,1,2);
plot(obs);
hold on;
title('Observation and Kalman Smoother (Dashed line is smoother)')
plot(smooth(2:end,1),'--r','Linewidth',2);
hold off

saveas(gcf,'fig1','fig');

sigma

for d=2:size(smooth,1)
    result(d-1,1)=smooth(d,1);
    result(d-1,2)=sqrt(smooth(d,2));
end;


phi=obs+obsd.datareg(:,5);
lag=obsd.datareg(:,5);
for a=1:size(phi,1)
    phihat(a,1)=z(a,1)*result(a,1)+lag(a,1);
end;


numperiod=size(phi,1);
yhatn11=phihat;
yn11=phi;

        sum11=0;
        summod11=0;
        sumtot11=0;
        

        for j=1:(numperiod)
            errorn11(j,1)=yhatn11(j,1)-yn11(j,1);
            sum11=(errorn11(j,1))^2+sum11;
            %summod11=summod11+(yhatn11(j,1)-dummymean)^2;
            sumtot11=sumtot11+(yn11(j,1)-mean(yn11))^2;
        end;
        %sumtot11=sum11+summod11;
        Rsquare11=1 - sum11/sumtot11
